<?php
    /*
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $arrayColonneHomePage = array("italiano"=>"homePage","inglese"=>"homePageEn","tedesco"=>"homePageDe","francese"=>"homePageFr","spagnolo"=>"homePageEs")
?>

<form name="formAggiornamentoImpostazioniLingue" action="../controller/controllerImpostazioni.php" method="post">
    <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniLingue">
    <h4 class="mb-4 title">Lingue</h4>
        <div class="row mt-5">
            <?php 
                if($impostazioni["aspettoSito"]!="sidebarScomparsaSx" && $impostazioni["aspettoSito"]!="sidebarScomparsaSxLogoCentrale") {
                    ?>
                    <div class="col-12">
                        <div class="alert alert-info">L'aspetto attuale non ti consente di visualizzare il menu secondario</div>
                    </div>
                    <?php
                }

                foreach($lingue as $lingua) {
                    $linguaLetteraMaiuscola = ucfirst($lingua);
                    if($impostazioni["linguaSito"]==$lingua) {
                        $classeDiv = "show active";
                    }
                    else {
                        $classeDiv = "";
                    }
            ?>
                <div class="col-6 col-lg-1">
                    <div class="form-group">
                        <label for="descrizione" class="d-block"><?php echo $lingua ?></label>
                        <input type="checkbox" id="registrazioneUtenti" name="impostazioni<?php echo $linguaLetteraMaiuscola ?>" class="js-switch" value="si" <?php echo(($impostazioniLingue["impostazioni$linguaLetteraMaiuscola"]=="si") ? "checked" : "") ?> />
                    </div>
                </div>

                <div class="col-6 col-lg-1">
                    <div class="form-group">
                        <label for="descrizione" class="d-block">Principale </label>
                        <input type="checkbox" id="registrazioneUtenti" class="js-switch" value="si" <?php echo(($impostazioniLingue["linguaPrincipale"]==$lingua) ? "checked" : "") ?>  onchange="aggiornaLinguaPrincipale('<?php echo $lingua ?>')" />
                    </div>
                </div>

                <div class="col-lg-2">
                    <div class="form-group">
                        <label for="metadescription">Menu principale</label>
                        <select name="menu<?php echo $linguaLetteraMaiuscola ?>" class="form-control">
                            <option value="0">Seleziona</option>
                            <?php
                                $queryComponentiDaMostrare = "SELECT * FROM geecB_menu";
                                $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                while($menu = $risComponenti->fetch_assoc()) {
                                    $selezionato = "";
                                    if($impostazioniLingue["menu$linguaLetteraMaiuscola"]==$menu["id"]) {
                                        $selezionato = "selected";
                                    }
                                    echo"<option value=\"{$menu["id"]}\" $selezionato >{$menu["nome"]}</option>";
                                }
                            ?>
                        </select>
                        <small class="text-muted">Menu principale per la lingua <b><?php echo $lingua ?></b></small>
                    </div>
                </div>

                <div class="col-lg-2">
                    <div class="form-group">
                        <label for="metadescription">Menu secondario</label>
                        <select name="menuSecondario<?php echo $linguaLetteraMaiuscola ?>" class="form-control" >
                            <option value="-1">Seleziona</option>
                            <?php
                                $queryComponentiDaMostrare = "SELECT * FROM geecB_menu";
                                $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                while($menu = $risComponenti->fetch_assoc()) {
                                    $selezionato = "";
                                    if($impostazioniLingue["menuSecondario$linguaLetteraMaiuscola"]==$menu["id"]) {
                                        $selezionato = "selected";
                                    }
                                    echo"<option value=\"{$menu["id"]}\" $selezionato >{$menu["nome"]}</option>";
                                }
                            ?>
                        </select>
                        <small class="text-muted">Menu secondario per la lingua <b><?php echo $lingua ?></b></small>
                    </div>
                </div>
            
                <div class="col-lg-2">
                    <div class="form-group">
                        <label for="metadescription">Home page</label>
                        <select name="homePage<?php echo $linguaLetteraMaiuscola ?>" class="form-control">
                            <option value="0">Seleziona</option>
                            <?php
                                $colonnaHomePage = $arrayColonneHomePage[$lingua];
                                $queryComponentiDaMostrare = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'pagina' AND linguaContenuto LIKE '$lingua'";
                                $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                while($pagina = $risComponenti->fetch_assoc()) {
                                    $selezionato = "";
                                    if($impostazioni[$colonnaHomePage]==$pagina["id"]) {
                                        $selezionato = "selected";
                                    }
                                    echo"<option value=\"{$pagina["id"]}\" $selezionato >{$pagina["titolo"]}</option>";
                                }
                            ?>
                        </select>
                        <small class="text-muted">Home page per la lingua <b><?php echo $lingua ?></b></small>
                    </div>
                </div>
            
                <div class="col-lg-2">
                    <div class="form-group">
                        <label for="metadescription">Blog</label>
                        <select name="paginaBlog<?php echo $linguaLetteraMaiuscola ?>" class="form-control">
                            <option value="0">Seleziona</option>
                            <?php
                                $queryComponentiDaMostrare = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'pagina' AND linguaContenuto LIKE '$lingua'";
                                $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                                while($pagina = $risComponenti->fetch_assoc()) {
                                    $selezionato = "";
                                    if($impostazioniLingue["paginaBlog$linguaLetteraMaiuscola"]==$pagina["id"]) {
                                        $selezionato = "selected";
                                    }
                                    echo"<option value=\"{$pagina["id"]}\" $selezionato >{$pagina["titolo"]}</option>";
                                }
                            ?>
                        </select>
                        <small class="text-muted">Pagina blog per la lingua <b><?php echo $lingua ?></b></small>
                    </div>
                </div>
            
                <div class="w-100"></div>
            <?php   
                }
            ?>
            
            <div class="footer">
                <button class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
            </div>
        </div>
    </form>